/*
 * Copyright (c) 1999, 2000, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.util.regex;

import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.framework.qual.AnnotatedFor;

@AnnotatedFor({ "index", "interning" })
@UsesObjectEquals
final class ASCII {

    static int getType(int ch);

    static boolean isType(int ch, int type);

    static boolean isAscii(int ch);

    static boolean isAlpha(int ch);

    static boolean isDigit(int ch);

    static boolean isAlnum(int ch);

    static boolean isGraph(int ch);

    static boolean isPrint(int ch);

    static boolean isPunct(int ch);

    static boolean isSpace(int ch);

    static boolean isHexDigit(int ch);

    static boolean isOctDigit(int ch);

    static boolean isCntrl(int ch);

    static boolean isLower(int ch);

    static boolean isUpper(int ch);

    static boolean isWord(int ch);

    static int toDigit(int ch);

    static int toLower(int ch);

    static int toUpper(int ch);
}
