/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.afu.annotator.scanner.CommonScanner;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;

public class MemberReferenceScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToMemberReferenceOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfMemberReferenceTree(TreePath origpath, Tree tree) {
        TreePath path = TreePathUtil.findCountingContext(origpath);
        if (path == null) {
            return -1;
        }
        MemberReferenceScanner mcs = new MemberReferenceScanner(tree);
        mcs.scan(path, null);
        return mcs.index;
    }

    private MemberReferenceScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitMemberReference(MemberReferenceTree node, Void p) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
        }
        return (Void)super.visitMemberReference(node, null);
    }

    public static void addMemberReferenceToMethod(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToMemberReferenceOffsets.get(methodName);
        if (offsetList == null) {
            offsetList = new ArrayList<Integer>();
            methodNameToMemberReferenceOffsets.put(methodName, offsetList);
        }
        offsetList.add(offset);
    }

    public static Integer getMemberReferenceIndex(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToMemberReferenceOffsets.get(methodName);
        if (offsetList == null) {
            return -1;
        }
        return offsetList.indexOf(offset);
    }
}

