/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.sql.JoinFragment;

public class QueryJoinFragment
extends JoinFragment {
    private StringBuffer afterFrom = new StringBuffer();
    private StringBuffer afterWhere = new StringBuffer();
    private Dialect dialect;

    public QueryJoinFragment(Dialect dialect) {
        this.dialect = dialect;
    }

    public void addJoin(String tableName, String alias, String[] fkColumns, String[] pkColumns, int joinType) {
        this.addJoin(tableName, alias, alias, fkColumns, pkColumns, joinType);
    }

    private void addJoin(String tableName, String alias, String concreteAlias, String[] fkColumns, String[] pkColumns, int joinType) {
        if (joinType != 0) {
            JoinFragment jf = this.dialect.createOuterJoinFragment();
            jf.addJoin(tableName, alias, fkColumns, pkColumns, joinType);
            this.addFragment(jf);
        } else {
            this.addCrossJoin(tableName, alias);
            this.addCondition(concreteAlias, fkColumns, pkColumns);
        }
    }

    public String toFromFragmentString() {
        return this.afterFrom.toString();
    }

    public String toWhereFragmentString() {
        return this.afterWhere.toString();
    }

    public void addJoins(String fromFragment, String whereFragment) {
        this.afterFrom.append(fromFragment);
        this.afterWhere.append(whereFragment);
    }

    public JoinFragment copy() {
        QueryJoinFragment copy = new QueryJoinFragment(this.dialect);
        copy.afterFrom = new StringBuffer(this.afterFrom.toString());
        copy.afterWhere = new StringBuffer(this.afterWhere.toString());
        return copy;
    }

    public void addCondition(String alias, String[] columns, String condition) {
        int i = 0;
        while (i < columns.length) {
            this.afterWhere.append(" and ").append(alias).append('.').append(columns[i]).append(condition);
            ++i;
        }
    }

    public void addCrossJoin(String tableName, String alias) {
        this.afterFrom.append(", ").append(tableName).append(' ').append(alias);
    }

    public void addCondition(String alias, String[] fkColumns, String[] pkColumns) {
        int j = 0;
        while (j < fkColumns.length) {
            this.afterWhere.append(" and ").append(fkColumns[j]).append('=').append(alias).append('.').append(pkColumns[j]);
            ++j;
        }
    }

    public void addCondition(String condition) {
        if (!condition.startsWith(" and ")) {
            this.afterWhere.append(" and ");
        }
        this.afterWhere.append(condition);
    }
}

