/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.id.SequenceGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.PropertiesHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SequenceHiLoGenerator
extends SequenceGenerator {
    public static final String MAX_LO = "max_lo";
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$id$SequenceHiLoGenerator == null ? (class$net$sf$hibernate$id$SequenceHiLoGenerator = SequenceHiLoGenerator.class$("net.sf.hibernate.id.SequenceHiLoGenerator")) : class$net$sf$hibernate$id$SequenceHiLoGenerator));
    private int maxLo;
    private int lo;
    private long hi;
    private Class returnClass;
    static /* synthetic */ Class class$net$sf$hibernate$id$SequenceHiLoGenerator;

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        super.configure(type, params, d);
        this.maxLo = PropertiesHelper.getInt(MAX_LO, params, 9);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws SQLException, HibernateException {
        if (this.lo > this.maxLo) {
            long hival = ((Number)super.generate(session, obj)).longValue();
            this.lo = 1;
            this.hi = hival * (long)(this.maxLo + 1);
            log.debug((Object)("new hi value: " + hival));
        }
        return IdentifierGeneratorFactory.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

