/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.MckoiCaseFragment;

public class MckoiDialect
extends Dialect {
    public MckoiDialect() {
        this.register(-7, "BIT");
        this.register(-5, "BIGINT");
        this.register(5, "SMALLINT");
        this.register(-6, "TINYINT");
        this.register(4, "INTEGER");
        this.register(1, "CHAR(1)");
        this.register(12, "VARCHAR($l)");
        this.register(6, "FLOAT");
        this.register(8, "DOUBLE");
        this.register(91, "DATE");
        this.register(92, "TIME");
        this.register(93, "TIMESTAMP");
        this.register(-3, "VARBINARY");
        this.register(2, "NUMERIC");
        this.register(2004, "BLOB");
        this.register(2005, "CLOB");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "SELECT UNIQUEKEY('" + sequenceName + "')";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "CREATE TABLE " + sequenceName + "(id NUMERIC)";
    }

    public String getDropSequenceString(String sequenceName) {
        return "DROP TABLE " + sequenceName;
    }

    public boolean supportsForUpdate() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public CaseFragment createCaseFragment() {
        return new MckoiCaseFragment();
    }
}

