/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.afu.scenelib.el.ADeclaration;
import org.checkerframework.afu.scenelib.el.AExpression;
import org.checkerframework.afu.scenelib.el.ElementVisitor;
import org.checkerframework.afu.scenelib.util.coll.VivifyingMap;

public class AField
extends ADeclaration {
    private String name;
    private TypeMirror typeMirror;
    public AExpression init;
    private Pattern digits = Pattern.compile("^[0-9]+$");

    public AField(String name) {
        super(name);
        this.name = name;
        this.typeMirror = null;
        this.init = null;
    }

    public AField(String name, TypeMirror typeMirror) {
        super(name);
        this.name = name;
        this.typeMirror = typeMirror;
        this.init = null;
    }

    public AField(AField field) {
        super(field.description, field);
        this.name = field.name;
        this.typeMirror = field.typeMirror;
        this.init = field.init == null ? null : field.init.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (this.name.equals(newName)) {
            return;
        }
        if (this.digits.matcher(this.name).matches()) {
            this.name = newName;
            this.description = newName;
            return;
        }
        throw new Error(String.format("old name=%s, new name=%s", this.name, newName));
    }

    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    public void setTypeMirror(TypeMirror typeMirror) {
        this.typeMirror = typeMirror;
    }

    @Override
    public AField clone() {
        return new AField(this);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof AField && this.equalsField((AField)o);
    }

    final boolean equalsField(AField o) {
        return super.equals(o);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AField ");
        sb.append(this.name);
        sb.append(" [typeMirror=" + this.typeMirror + "; init=" + this.init + "; annos=");
        this.tlAnnotationsHereFormatted(sb);
        sb.append("; type=");
        this.type.tlAnnotationsHereFormatted(sb);
        sb.append("] ");
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitField(this, t);
    }

    static <K> VivifyingMap<K, AField> newVivifyingLHMap_AF() {
        return new VivifyingMap<K, AField>((Map)new LinkedHashMap()){

            @Override
            public AField createValueFor(K k) {
                return new AField("" + k);
            }

            @Override
            public boolean isEmptyValue(AField v) {
                return v.isEmpty();
            }
        };
    }
}

