/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.scenelib.el.BoundLocation;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BoundLocationCriterion
implements Criterion {
    private Criterion parentCriterion;
    private final int boundIndex;
    private final int paramIndex;

    public BoundLocationCriterion(BoundLocation boundLoc) {
        this(boundLoc.boundIndex, boundLoc.paramIndex);
    }

    private BoundLocationCriterion(int boundIndex, int paramIndex) {
        this.boundIndex = boundIndex;
        this.paramIndex = paramIndex;
        if (boundIndex != -1) {
            this.parentCriterion = new BoundLocationCriterion(-1, paramIndex);
        } else if (paramIndex != -1) {
            this.parentCriterion = null;
        }
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return false;
        }
        Tree parent = parentPath.getLeaf();
        if (parent == null) {
            return false;
        }
        boolean returnValue = false;
        if (this.boundIndex != -1) {
            if (parent instanceof TypeParameterTree) {
                boolean foundLeaf;
                List<? extends Tree> bounds = ((TypeParameterTree)parent).getBounds();
                int ix = this.boundIndex;
                if (!bounds.isEmpty() && this.isInterface((JCTree.JCExpression)bounds.get(0))) {
                    --ix;
                }
                boolean bl = foundLeaf = ix < 0 || ix < bounds.size() && bounds.get(ix) == leaf;
                if (foundLeaf) {
                    returnValue = this.parentCriterion.isSatisfiedBy(parentPath);
                }
            } else if (this.boundIndex == 0 && leaf instanceof TypeParameterTree) {
                List<? extends Tree> bounds = ((TypeParameterTree)leaf).getBounds();
                if (bounds.isEmpty() || this.isInterface((JCTree.JCExpression)bounds.get(0))) {
                    returnValue = this.parentCriterion.isSatisfiedBy(path);
                } else {
                    Type type = ((JCTree.JCExpression)bounds.get((int)0)).type;
                    if (type != null && type.tsym != null && type.tsym.isInterface()) {
                        returnValue = this.parentCriterion.isSatisfiedBy(parentPath);
                    }
                }
            }
        } else if (this.paramIndex != -1 && (parent instanceof MethodTree || parent instanceof ClassTree)) {
            List<? extends TypeParameterTree> params = null;
            if (parent instanceof MethodTree) {
                params = ((MethodTree)parent).getTypeParameters();
            } else if (parent instanceof ClassTree) {
                params = ((ClassTree)parent).getTypeParameters();
            }
            if (this.paramIndex < params.size()) {
                boolean foundLeaf;
                boolean bl = foundLeaf = params.get(this.paramIndex) == leaf;
                if (foundLeaf) {
                    returnValue = true;
                }
            }
        }
        if (!returnValue) {
            return this.isSatisfiedBy(parentPath);
        }
        return true;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return true;
    }

    private boolean isInterface(JCTree.JCExpression bound) {
        Type type = bound.type;
        return type != null && type.tsym != null && type.tsym.isInterface();
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.BOUND_LOCATION;
    }

    public String toString() {
        return "BoundCriterion: at param index: " + this.paramIndex + " at bound index: " + this.boundIndex;
    }
}

