/*
 * Copyright (c) 1997, 2000, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package javax.swing;

import org.checkerframework.checker.fenum.qual.*;
import org.checkerframework.framework.qual.AnnotatedFor;
import org.checkerframework.framework.qual.CFComment;

@AnnotatedFor("fenum")
public interface SwingConstants {

    @SwingCompassDirection
    @SwingHorizontalOrientation
    @SwingVerticalOrientation
    public static final int CENTER;

    @SwingVerticalOrientation
    public static final int TOP;

    @SwingHorizontalOrientation
    public static final int LEFT;

    @SwingVerticalOrientation
    public static final int BOTTOM;

    @SwingHorizontalOrientation
    public static final int RIGHT;

    @SwingCompassDirection
    public static final int NORTH;

    @SwingCompassDirection
    public static final int NORTH_EAST;

    @SwingCompassDirection
    public static final int EAST;

    @SwingCompassDirection
    public static final int SOUTH_EAST;

    @SwingCompassDirection
    public static final int SOUTH;

    @SwingCompassDirection
    public static final int SOUTH_WEST;

    @SwingCompassDirection
    public static final int WEST;

    @SwingCompassDirection
    public static final int NORTH_WEST;

    @SwingElementOrientation
    public static final int HORIZONTAL;

    @SwingElementOrientation
    public static final int VERTICAL;

    @SwingHorizontalOrientation
    @SwingTextOrientation
    public static final int LEADING;

    @SwingHorizontalOrientation
    @SwingTextOrientation
    public static final int TRAILING;

    @SwingTextOrientation
    public static final int NEXT;

    @SwingTextOrientation
    public static final int PREVIOUS;
}
