/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.util.LinkedHashSet;
import java.util.Set;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.el.ABlock;
import org.checkerframework.afu.scenelib.el.AClass;
import org.checkerframework.afu.scenelib.el.ADeclaration;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.AScene;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.ATypeElementWithType;
import org.checkerframework.afu.scenelib.el.AnnotationDef;
import org.checkerframework.afu.scenelib.el.DefException;
import org.checkerframework.afu.scenelib.field.AnnotationAFT;
import org.checkerframework.afu.scenelib.field.AnnotationFieldType;

public abstract class DefCollector {
    private final Set<AnnotationDef> defs = new LinkedHashSet<AnnotationDef>();

    public DefCollector(AScene s) throws DefException {
        this.collect(s);
    }

    private AnnotationDef getDef(String name) {
        for (AnnotationDef def : this.defs) {
            if (!def.name.equals(name)) continue;
            return def;
        }
        return null;
    }

    private void collect(AScene s) throws DefException {
        for (AElement p : s.packages.values()) {
            this.collect(p);
        }
        for (AClass c : s.classes.values()) {
            this.collect(c);
        }
    }

    private void addToDefs(AnnotationDef d) throws DefException {
        if (this.defs.contains(d)) {
            return;
        }
        AnnotationDef oldD = this.getDef(d.name);
        if (oldD == null) {
            this.defs.add(d);
        } else {
            AnnotationDef ud = AnnotationDef.unify(oldD, d);
            if (ud == null) {
                throw new DefException(d.name, oldD, d);
            }
            this.defs.remove(oldD);
            this.defs.add(ud);
        }
    }

    private void collect(AnnotationDef d) throws DefException {
        if (this.defs.contains(d)) {
            return;
        }
        for (AnnotationFieldType aft : d.fieldTypes.values()) {
            if (!(aft instanceof AnnotationAFT)) continue;
            this.collect(((AnnotationAFT)aft).annotationDef);
        }
        this.addToDefs(d);
    }

    private void collect(AElement e) throws DefException {
        if (e == null) {
            return;
        }
        for (Annotation tla : e.tlAnnotationsHere) {
            this.collect(tla);
        }
        if (e.type != null) {
            this.collect(e.type);
        }
    }

    private void collect(Annotation a) throws DefException {
        AnnotationDef d = a.def;
        if (!this.defs.contains(d)) {
            this.collect(d);
            this.addToDefs(d);
        }
    }

    private void collect(ATypeElement t) throws DefException {
        this.collect((AElement)t);
        for (ATypeElement it : t.innerTypes.values()) {
            this.collect(it);
        }
    }

    private void collect(ADeclaration d) throws DefException {
        this.collect((AElement)d);
        for (ATypeElement ia : d.insertAnnotations.values()) {
            this.collect(ia);
        }
        for (ATypeElementWithType ic : d.insertTypecasts.values()) {
            this.collect(ic);
        }
    }

    private void collect(AField f) throws DefException {
        this.collect((ADeclaration)f);
        this.collect(f.init);
    }

    private void collect(AMethod m) throws DefException {
        this.collect((ADeclaration)m);
        for (ATypeElement b : m.bounds.values()) {
            this.collect(b);
        }
        this.collect(m.returnType);
        this.collect(m.receiver);
        for (AField p : m.parameters.values()) {
            this.collect(p);
        }
        for (AElement e : m.throwsException.values()) {
            this.collect((ATypeElement)e);
        }
        for (AElement e : m.preconditions.values()) {
            this.collect(e);
        }
        for (AElement e : m.postconditions.values()) {
            this.collect(e);
        }
        for (Annotation a : m.contracts) {
            this.collect(a);
        }
        this.collect(m.body);
    }

    private void collect(ABlock b) throws DefException {
        for (AField l : b.locals.values()) {
            this.collect(l);
        }
        for (ATypeElement tc : b.typecasts.values()) {
            this.collect(tc);
        }
        for (ATypeElement i : b.instanceofs.values()) {
            this.collect(i);
        }
        for (ATypeElement n : b.news.values()) {
            this.collect(n);
        }
    }

    private void collect(AClass c) throws DefException {
        this.collect((ADeclaration)c);
        for (ATypeElement b : c.bounds.values()) {
            this.collect(b);
        }
        for (ATypeElement ei : c.extendsImplements.values()) {
            this.collect(ei);
        }
        for (AMethod m : c.methods.values()) {
            this.collect(m);
        }
        for (AField f : c.fields.values()) {
            this.collect(f);
        }
    }

    protected abstract void visitAnnotationDef(AnnotationDef var1);

    public final void visit() {
        for (AnnotationDef d : this.defs) {
            this.visitAnnotationDef(d);
        }
    }
}

