/*
 * Copyright (c) 2018, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.lang.constant;

import org.checkerframework.checker.signature.qual.MethodDescriptor;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public sealed interface MethodTypeDesc extends ConstantDesc, TypeDescriptor.OfMethod<ClassDesc, MethodTypeDesc> permits MethodTypeDescImpl {

    static MethodTypeDesc ofDescriptor(String descriptor);

    static MethodTypeDesc of(ClassDesc returnDesc);

    static MethodTypeDesc of(ClassDesc returnDesc, List<ClassDesc> paramDescs);

    static MethodTypeDesc of(ClassDesc returnDesc, ClassDesc... paramDescs);

    ClassDesc returnType();

    int parameterCount();

    ClassDesc parameterType(int index);

    List<ClassDesc> parameterList();

    ClassDesc[] parameterArray();

    MethodTypeDesc changeReturnType(ClassDesc returnType);

    MethodTypeDesc changeParameterType(int index, ClassDesc paramType);

    MethodTypeDesc dropParameterTypes(int start, int end);

    MethodTypeDesc insertParameterTypes(int pos, ClassDesc... paramTypes);

    @MethodDescriptor
    String descriptorString();

    default String displayDescriptor();

    @Override
    MethodType resolveConstantDesc(MethodHandles.Lookup lookup) throws ReflectiveOperationException;

    boolean equals(Object o);
}
