/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.io;

import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;

class ImmutableStack<E> {
    private E elem = null;
    private ImmutableStack<E> rest = null;
    private int size = 0;

    private static <T, S extends ImmutableStack<T>> S extend(T el, S s0) {
        try {
            ImmutableStack s1;
            ImmutableStack cs = s1 = (ImmutableStack)s0.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            cs.size = 1 + s0.size();
            cs.elem = el;
            cs.rest = s0;
            return (S)s1;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public E peek() {
        if (this.isEmpty()) {
            throw new IllegalStateException("peek() on empty stack");
        }
        return this.elem;
    }

    public ImmutableStack<E> pop() {
        if (this.isEmpty()) {
            throw new IllegalStateException("pop() on empty stack");
        }
        return this.rest;
    }

    public ImmutableStack<E> push(E elem) {
        return ImmutableStack.extend(elem, this);
    }

    public int size() {
        return this.size;
    }

    public E get(int index) {
        int n = this.size();
        if (0 > index || index >= n) {
            throw new NoSuchElementException("Has " + n + " elements, asked for #" + index);
        }
        ImmutableStack<E> s = this;
        while (--n > index) {
            s = s.pop();
        }
        return s.peek();
    }

    public String toString() {
        if (this.size > 0) {
            StringBuilder sb = new StringBuilder("]").insert(0, this.peek());
            ImmutableStack<E> stack = this.pop();
            while (!stack.isEmpty()) {
                sb = sb.insert(0, ", ").insert(0, stack.peek());
                stack = stack.pop();
            }
            return sb.insert(0, "[").toString();
        }
        return "[]";
    }
}

