/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Name;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.AnonymousClassScanner;
import org.checkerframework.afu.annotator.scanner.LocalClassScanner;
import org.checkerframework.checker.formatter.qual.FormatMethod;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.signature.qual.ClassGetName;

public final class InClassCriterion
implements Criterion {
    static boolean debug = false;
    public final @ClassGetName String className;
    private final boolean exactMatch;
    static Pattern anonclassPattern = Pattern.compile("^([0-9]+)(\\$(.*))?$");
    static Pattern localClassPattern = Pattern.compile("^([0-9]+)([^$]+)(\\$(.*))?$");

    public InClassCriterion(@ClassGetName String className, boolean exactMatch) {
        this.className = className;
        this.exactMatch = exactMatch;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.IN_CLASS;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        return InClassCriterion.isSatisfiedBy(path, this.className, this.exactMatch);
    }

    public static boolean isSatisfiedBy(@Nullable TreePath path, String className, boolean exactMatch) {
        if (path == null) {
            return false;
        }
        String cname = className;
        ArrayList<Tree> trees = new ArrayList<Tree>();
        for (Tree tree : path) {
            trees.add(tree);
        }
        Collections.reverse(trees);
        boolean insideMatch = false;
        for (int i = 0; i < trees.size(); ++i) {
            Tree tree = (Tree)trees.get(i);
            boolean checkAnon = false;
            boolean checkLocal = false;
            switch (tree.getKind()) {
                case COMPILATION_UNIT: {
                    InClassCriterion.debug("InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                    ExpressionTree packageTree = ((CompilationUnitTree)tree).getPackageName();
                    if (packageTree == null) break;
                    String declaredPackage = packageTree.toString();
                    if (cname.startsWith(declaredPackage + ".")) {
                        cname = cname.substring(declaredPackage.length() + 1);
                        break;
                    }
                    InClassCriterion.debug("false[COMPILATION_UNIT; bad declaredPackage = %s] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", declaredPackage, cname, tree);
                    return false;
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    if (i > 0 && trees.get(i - 1) instanceof NewClassTree) break;
                    InClassCriterion.debug("InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                    if (i > 0 && trees.get(i - 1) instanceof BlockTree) {
                        checkLocal = true;
                        InClassCriterion.debug("found local class: InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                        break;
                    }
                    ClassTree c = (ClassTree)tree;
                    Name csn = c.getSimpleName();
                    if (csn == null || csn.length() == 0) {
                        InClassCriterion.debug("empty getSimpleName: InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                        checkAnon = true;
                        break;
                    }
                    String treeClassName = csn.toString();
                    if (cname.equals(treeClassName)) {
                        if (exactMatch) {
                            cname = "";
                            break;
                        }
                        InClassCriterion.debug("true InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                        return true;
                    }
                    if (cname.startsWith(treeClassName + "$") || cname.startsWith(treeClassName + ".")) {
                        cname = cname.substring(treeClassName.length() + 1);
                        break;
                    }
                    if (treeClassName.isEmpty()) break;
                    InClassCriterion.debug("false InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                    return false;
                }
                case NEW_CLASS: {
                    InClassCriterion.debug("InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                    if (cname.equals("")) {
                        insideMatch = true;
                        break;
                    }
                    NewClassTree nc = (NewClassTree)tree;
                    checkAnon = nc.getClassBody() != null;
                    break;
                }
                case METHOD: 
                case VARIABLE: {
                    if (!insideMatch) break;
                    InClassCriterion.debug("false InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                    return false;
                }
            }
            if (checkAnon) {
                int anonclassNum;
                Matcher anonclassMatcher = anonclassPattern.matcher(cname);
                if (!anonclassMatcher.matches()) {
                    InClassCriterion.debug("false[anonclassMatcher] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                    return false;
                }
                String anonclassNumString = anonclassMatcher.group(1);
                cname = anonclassMatcher.group(3);
                if (cname == null) {
                    cname = "";
                }
                try {
                    anonclassNum = Integer.parseInt(anonclassNumString);
                }
                catch (NumberFormatException e) {
                    throw new Error("This can't happen: " + cname + "$" + anonclassNumString, e);
                }
                int actualIndexInSource = AnonymousClassScanner.indexOfClassTree(path, tree);
                if (anonclassNum == actualIndexInSource) continue;
                InClassCriterion.debug("false[anonclassNum %d %d] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", anonclassNum, actualIndexInSource, cname, tree);
                return false;
            }
            if (!checkLocal) continue;
            ClassTree c = (ClassTree)tree;
            String treeClassName = c.getSimpleName().toString();
            Matcher localClassMatcher = localClassPattern.matcher(cname);
            if (!localClassMatcher.matches()) {
                InClassCriterion.debug("false[localClassMatcher] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname, tree);
                return false;
            }
            String localClassNumString = localClassMatcher.group(1);
            String localClassName = localClassMatcher.group(2);
            int localClassNum = Integer.parseInt(localClassNumString);
            int actualIndexInSource = LocalClassScanner.indexOfClassTree(path, c);
            if (actualIndexInSource == localClassNum && treeClassName.startsWith(localClassName)) {
                cname = localClassMatcher.group(4);
                if (cname != null) continue;
                cname = "";
                continue;
            }
            InClassCriterion.debug("false[localClassNum %d %d] InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", localClassNum, actualIndexInSource, cname, tree);
            return false;
        }
        InClassCriterion.debug("%s InClassCriterion.isSatisfiedBy:%n  cname=%s%n  tree=%s%n", cname.equals(""), cname, path.getLeaf());
        return cname.equals("");
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    public String toString() {
        return "In class '" + this.className + "'" + (this.exactMatch ? " (exactly)" : "");
    }

    @FormatMethod
    private static void debug(String message, Object ... args) {
        if (debug) {
            System.out.printf(message, args);
        }
    }
}

