/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.mustcall.qual.MustCall;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.plumelib.util.UtilPlume;

public final class SystemPlume {
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Runtime runtime = Runtime.getRuntime();
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Deque<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) GcHistoryItem> gcHistory = new ArrayDeque<GcHistoryItem>();

    private SystemPlume() {
        throw new Error("do not instantiate");
    }

    @Pure
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean getBooleanSystemProperty(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String key, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean defaultValue) {
        return UtilPlume.getBooleanProperty(System.getProperties(), key, defaultValue);
    }

    @Pure
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean getBooleanSystemProperty(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String key) {
        return SystemPlume.getBooleanSystemProperty(key, false);
    }

    public static void sleep(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long usedMemory() {
        return SystemPlume.usedMemory(false);
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long usedMemory(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean forceGc) {
        if (forceGc) {
            SystemPlume.gc();
        }
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static void gc() {
        long oldCollectionCount = SystemPlume.getCollectionCount();
        System.gc();
        while (SystemPlume.getCollectionCount() == oldCollectionCount) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long getCollectionCount() {
        long result = 0L;
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = b.getCollectionCount();
            if (count == -1L) continue;
            result += count;
        }
        return result;
    }

    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long getCollectionTime() {
        long result = 0L;
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time = b.getCollectionTime();
            if (time == -1L) continue;
            result += time;
        }
        return result;
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) double gcPercentage() {
        return SystemPlume.gcPercentage(60);
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) double gcPercentage(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int seconds) {
        long collectionTime;
        GcHistoryItem newest = gcHistory.getLast();
        long now = Instant.now().getEpochSecond();
        if (now == newest.timestamp) {
            collectionTime = newest.collectionTime;
        } else {
            newest.subsequentTimestamp = now;
            collectionTime = SystemPlume.getCollectionTime();
            newest = new GcHistoryItem(now, collectionTime);
            gcHistory.add(newest);
        }
        GcHistoryItem oldest = gcHistory.getFirst();
        while (oldest.subsequentTimestamp != 0L && now - oldest.subsequentTimestamp > (long)seconds) {
            gcHistory.removeFirst();
            oldest = gcHistory.getFirst();
        }
        long elapsed = now - oldest.timestamp;
        if (elapsed < (long)seconds) {
            return 0.0;
        }
        double elapsedCollectionTime = (double)(collectionTime - oldest.collectionTime) / 1000.0;
        return elapsedCollectionTime / (double)elapsed;
    }

    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String gcUsageMessage(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) double cpuThreshold, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int seconds) {
        double gcPercentage = SystemPlume.gcPercentage(seconds);
        if (gcPercentage < cpuThreshold) {
            return null;
        }
        return String.join((CharSequence)System.lineSeparator(), "Garbage collection consumed " + Math.round(gcPercentage * 100.0) + "% of CPU during the past " + seconds + " seconds.", "  max memory = " + Runtime.getRuntime().maxMemory(), "total memory = " + Runtime.getRuntime().totalMemory(), " free memory = " + Runtime.getRuntime().freeMemory());
    }

    static {
        long epochSecond = Instant.now().getEpochSecond();
        gcHistory.add(new GcHistoryItem(epochSecond, SystemPlume.getCollectionTime()));
    }

    private static class GcHistoryItem {
        @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long timestamp;
        @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long collectionTime;
        @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long subsequentTimestamp = 0L;

        GcHistoryItem(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long timestamp, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) long collectionTime) {
            this.timestamp = timestamp;
            this.collectionTime = collectionTime;
        }
    }
}

