/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.el;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.interning.qual.InternedDistinct;
import org.objectweb.asm.TypePath;

public class TypePathEntry {
    public final int step;
    public final int argument;
    public static final @InternedDistinct TypePathEntry ARRAY_ELEMENT = new TypePathEntry(0, 0);
    public static final @InternedDistinct TypePathEntry INNER_TYPE = new TypePathEntry(1, 0);
    public static final @InternedDistinct TypePathEntry WILDCARD_BOUND = new TypePathEntry(2, 0);

    private TypePathEntry(int step, int argument) {
        this.step = step;
        this.argument = argument;
    }

    public static TypePathEntry create(int step, int argument) {
        switch (step) {
            case 0: {
                assert (argument == 0);
                return ARRAY_ELEMENT;
            }
            case 1: {
                assert (argument == 0);
                return INNER_TYPE;
            }
            case 2: {
                assert (argument == 0);
                return WILDCARD_BOUND;
            }
            case 3: {
                return new TypePathEntry(step, argument);
            }
        }
        throw new Error("Bad step " + step);
    }

    public boolean equals(TypePathEntry o) {
        return this.step == o.step && this.argument == o.argument;
    }

    public boolean equals(Object o) {
        return o instanceof TypePathEntry && this.equals((TypePathEntry)o);
    }

    public int hashCode() {
        return Objects.hash(this.step, this.argument);
    }

    public static String toString(int step, int argument) {
        switch (step) {
            case 0: {
                return "[";
            }
            case 1: {
                return ".";
            }
            case 2: {
                return "*";
            }
            case 3: {
                return String.valueOf(argument) + ";";
            }
        }
        throw new Error("Bad step " + step);
    }

    public String toString() {
        return "\"" + TypePathEntry.toString(this.step, this.argument) + "\"";
    }

    public static TypePath getTypePathFromBinary(List<Integer> integerList) {
        if (integerList == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Integer> iterator = integerList.iterator();
        while (iterator.hasNext()) {
            int step = iterator.next();
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("Odd number of elements: " + integerList);
            }
            int argument = iterator.next();
            stringBuilder.append(TypePathEntry.toString(step, argument));
        }
        return TypePath.fromString(stringBuilder.toString());
    }

    public static List<TypePathEntry> getTypePathEntryListFromBinary(List<Integer> integerList) {
        if (integerList == null) {
            return null;
        }
        ArrayList<TypePathEntry> typePathEntryList = new ArrayList<TypePathEntry>();
        Iterator<Integer> iterator = integerList.iterator();
        while (iterator.hasNext()) {
            int step = iterator.next();
            if (!iterator.hasNext()) {
                throw new IllegalArgumentException("Odd number of elements: " + integerList);
            }
            int argument = iterator.next();
            typePathEntryList.add(new TypePathEntry(step, argument));
        }
        return typePathEntryList;
    }

    public static TypePath listToTypePath(List<TypePathEntry> typePathEntryList) {
        if (typePathEntryList == null || typePathEntryList.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (TypePathEntry typePathEntry : typePathEntryList) {
            stringBuilder.append(TypePathEntry.toString(typePathEntry.step, typePathEntry.argument));
        }
        return TypePath.fromString(stringBuilder.toString());
    }

    public static List<TypePathEntry> typePathToList(TypePath typePath) {
        if (typePath == null) {
            return null;
        }
        ArrayList<TypePathEntry> typePathEntryList = new ArrayList<TypePathEntry>(typePath.getLength());
        for (int index = 0; index < typePath.getLength(); ++index) {
            typePathEntryList.add(new TypePathEntry(typePath.getStep(index), typePath.getStepArgument(index)));
        }
        return typePathEntryList;
    }
}

