/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReceiverCriterion
implements Criterion {
    private final String methodName;
    private final Criterion isSigMethodCriterion;

    public ReceiverCriterion(String methodName) {
        this.methodName = methodName;
        this.isSigMethodCriterion = Criteria.isSigMethod(methodName);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        TreePath parent;
        if (path == null) {
            return false;
        }
        if (path.getLeaf() instanceof MethodTree) {
            if (this.isSigMethodCriterion.isSatisfiedBy(path)) {
                MethodTree leaf = (MethodTree)path.getLeaf();
                return leaf.getReceiverParameter() == null;
            }
            return false;
        }
        Tree param = null;
        for (parent = path; parent != null && !(parent.getLeaf() instanceof MethodTree); parent = parent.getParentPath()) {
            if (!(parent.getLeaf() instanceof VariableTree)) continue;
            if (param == null) {
                param = parent.getLeaf();
                continue;
            }
            return false;
        }
        if (parent != null && param != null) {
            boolean foundParam;
            MethodTree method = (MethodTree)parent.getLeaf();
            boolean bl = foundParam = param == method.getReceiverParameter();
            if (foundParam) {
                return this.isSigMethodCriterion.isSatisfiedBy(parent);
            }
        }
        return false;
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return true;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.RECEIVER;
    }

    public String toString() {
        return "ReceiverCriterion for method: " + this.methodName;
    }
}

