/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package javax.swing.text;

import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.framework.qual.AnnotatedFor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.Icon;

@AnnotatedFor({ "interning" })
public class StyleConstants {

    @Interned
    public static final String ComponentElementName;

    @Interned
    public static final String IconElementName;

    public static final Object NameAttribute;

    public static final Object ResolveAttribute;

    public static final Object ModelAttribute;

    public String toString();

    public static final Object BidiLevel;

    public static final Object FontFamily;

    public static final Object Family;

    public static final Object FontSize;

    public static final Object Size;

    public static final Object Bold;

    public static final Object Italic;

    public static final Object Underline;

    public static final Object StrikeThrough;

    public static final Object Superscript;

    public static final Object Subscript;

    public static final Object Foreground;

    public static final Object Background;

    public static final Object ComponentAttribute;

    public static final Object IconAttribute;

    public static final Object ComposedTextAttribute;

    public static final Object FirstLineIndent;

    public static final Object LeftIndent;

    public static final Object RightIndent;

    public static final Object LineSpacing;

    public static final Object SpaceAbove;

    public static final Object SpaceBelow;

    public static final Object Alignment;

    public static final Object TabSet;

    public static final Object Orientation;

    public static final int ALIGN_LEFT;

    public static final int ALIGN_CENTER;

    public static final int ALIGN_RIGHT;

    public static final int ALIGN_JUSTIFIED;

    public static int getBidiLevel(AttributeSet a);

    public static void setBidiLevel(MutableAttributeSet a, int o);

    public static Component getComponent(AttributeSet a);

    public static void setComponent(MutableAttributeSet a, Component c);

    public static Icon getIcon(AttributeSet a);

    public static void setIcon(MutableAttributeSet a, Icon c);

    public static String getFontFamily(AttributeSet a);

    public static void setFontFamily(MutableAttributeSet a, String fam);

    public static int getFontSize(AttributeSet a);

    public static void setFontSize(MutableAttributeSet a, int s);

    public static boolean isBold(AttributeSet a);

    public static void setBold(MutableAttributeSet a, boolean b);

    public static boolean isItalic(AttributeSet a);

    public static void setItalic(MutableAttributeSet a, boolean b);

    public static boolean isUnderline(AttributeSet a);

    public static boolean isStrikeThrough(AttributeSet a);

    public static boolean isSuperscript(AttributeSet a);

    public static boolean isSubscript(AttributeSet a);

    public static void setUnderline(MutableAttributeSet a, boolean b);

    public static void setStrikeThrough(MutableAttributeSet a, boolean b);

    public static void setSuperscript(MutableAttributeSet a, boolean b);

    public static void setSubscript(MutableAttributeSet a, boolean b);

    public static Color getForeground(AttributeSet a);

    public static void setForeground(MutableAttributeSet a, Color fg);

    public static Color getBackground(AttributeSet a);

    public static void setBackground(MutableAttributeSet a, Color fg);

    public static float getFirstLineIndent(AttributeSet a);

    public static void setFirstLineIndent(MutableAttributeSet a, float i);

    public static float getRightIndent(AttributeSet a);

    public static void setRightIndent(MutableAttributeSet a, float i);

    public static float getLeftIndent(AttributeSet a);

    public static void setLeftIndent(MutableAttributeSet a, float i);

    public static float getLineSpacing(AttributeSet a);

    public static void setLineSpacing(MutableAttributeSet a, float i);

    public static float getSpaceAbove(AttributeSet a);

    public static void setSpaceAbove(MutableAttributeSet a, float i);

    public static float getSpaceBelow(AttributeSet a);

    public static void setSpaceBelow(MutableAttributeSet a, float i);

    public static int getAlignment(AttributeSet a);

    public static void setAlignment(MutableAttributeSet a, int align);

    public static TabSet getTabSet(AttributeSet a);

    public static void setTabSet(MutableAttributeSet a, TabSet tabs);

    public static class ParagraphConstants extends StyleConstants implements AttributeSet.ParagraphAttribute {
    }

    public static class CharacterConstants extends StyleConstants implements AttributeSet.CharacterAttribute {
    }

    public static class ColorConstants extends StyleConstants implements AttributeSet.ColorAttribute, AttributeSet.CharacterAttribute {
    }

    public static class FontConstants extends StyleConstants implements AttributeSet.FontAttribute, AttributeSet.CharacterAttribute {
    }
}
