/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.afu.annotator.scanner.CommonScanner;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;
import org.plumelib.util.IPair;

public class NewScanner
extends CommonScanner {
    private static boolean debug = false;
    static Map<IPair<TreePath, Tree>, Integer> cache = new HashMap<IPair<TreePath, Tree>, Integer>();
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToNewOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfNewTree(TreePath origpath, Tree tree) {
        NewScanner.debug("indexOfNewTree: " + origpath.getLeaf());
        IPair<TreePath, Tree> args = IPair.of(origpath, tree);
        if (cache.containsKey(args)) {
            return cache.get(args);
        }
        TreePath path = TreePathUtil.findCountingContext(origpath);
        if (path == null) {
            return -1;
        }
        NewScanner lvts = new NewScanner(tree);
        lvts.scan(path, null);
        cache.put(args, lvts.index);
        return lvts.index;
    }

    private NewScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void p) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
        }
        return (Void)super.visitNewClass(node, null);
    }

    @Override
    public Void visitNewArray(NewArrayTree node, Void p) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
        }
        return (Void)super.visitNewArray(node, null);
    }

    public static void debug(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    public static void addNewToMethod(String methodName, Integer offset) {
        NewScanner.debug("adding new to method: " + methodName + " offset: " + offset);
        List<Integer> offsetList = methodNameToNewOffsets.get(methodName);
        if (offsetList == null) {
            offsetList = new ArrayList<Integer>();
            methodNameToNewOffsets.put(methodName, offsetList);
        }
        offsetList.add(offset);
    }

    public static Integer getMethodNewIndex(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToNewOffsets.get(methodName);
        if (offsetList == null) {
            throw new RuntimeException("NewScanner.getMethodNewIndex() : did not find offsets for method: " + methodName);
        }
        Integer offsetIndex = offsetList.indexOf(offset);
        if (offsetIndex < 0) {
            throw new RuntimeException("NewScanner.getMethodNewIndex() : in method: " + methodName + " did not find offset: " + offset);
        }
        return offsetIndex;
    }
}

