/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.scanner;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.afu.annotator.scanner.CommonScanner;
import org.checkerframework.afu.annotator.scanner.TreePathUtil;

public class MethodCallScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToMethodCallOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfMethodCallTree(TreePath origpath, Tree tree) {
        TreePath path = TreePathUtil.findCountingContext(origpath);
        if (path == null) {
            return -1;
        }
        MethodCallScanner mcs = new MethodCallScanner(tree);
        mcs.scan(path, null);
        return mcs.index;
    }

    private MethodCallScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
        }
        return (Void)super.visitMethodInvocation(node, null);
    }

    public static void addMethodCallToMethod(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToMethodCallOffsets.get(methodName);
        if (offsetList == null) {
            offsetList = new ArrayList<Integer>();
            methodNameToMethodCallOffsets.put(methodName, offsetList);
        }
        offsetList.add(offset);
    }

    public static Integer getMethodCallIndex(String methodName, Integer offset) {
        List<Integer> offsetList = methodNameToMethodCallOffsets.get(methodName);
        if (offsetList == null) {
            return -1;
        }
        return offsetList.indexOf(offset);
    }
}

