/*
 * Copyright (c) 1995, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.net;

import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.framework.qual.AnnotatedFor;

@AnnotatedFor({ "interning" })
@UsesObjectEquals
public final class DatagramPacket {

    public DatagramPacket(byte[] buf, int offset, int length) {
    }

    public DatagramPacket(byte[] buf, int length) {
    }

    public DatagramPacket(byte[] buf, int offset, int length, InetAddress address, int port) {
    }

    public DatagramPacket(byte[] buf, int offset, int length, SocketAddress address) {
    }

    public DatagramPacket(byte[] buf, int length, InetAddress address, int port) {
    }

    public DatagramPacket(byte[] buf, int length, SocketAddress address) {
    }

    public synchronized InetAddress getAddress();

    public synchronized int getPort();

    public synchronized byte[] getData();

    public synchronized int getOffset();

    public synchronized int getLength();

    public synchronized void setData(byte[] buf, int offset, int length);

    public synchronized void setAddress(InetAddress iaddr);

    public synchronized void setPort(int iport);

    public synchronized void setSocketAddress(SocketAddress address);

    public synchronized SocketAddress getSocketAddress();

    public synchronized void setData(byte[] buf);

    public synchronized void setLength(int length);
}
