/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import org.checkerframework.afu.annotator.find.Criteria;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.NewScanner;
import org.checkerframework.afu.scenelib.el.RelativeLocation;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NewCriterion
implements Criterion {
    private final String methodName;
    private final Criterion inMethodCriterion;
    private final RelativeLocation loc;

    public NewCriterion(String methodName, RelativeLocation loc) {
        this.methodName = methodName.substring(0, methodName.lastIndexOf(41) + 1);
        this.inMethodCriterion = !methodName.startsWith("init for field") && !methodName.startsWith("static init number") && !methodName.startsWith("instance init number") ? Criteria.inMethod(methodName) : null;
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        if (path == null) {
            return false;
        }
        Tree leaf = path.getLeaf();
        if (this.inMethodCriterion != null && !this.inMethodCriterion.isSatisfiedBy(path)) {
            return this.isSatisfiedBy(path.getParentPath());
        }
        if (leaf instanceof NewClassTree || leaf instanceof NewArrayTree) {
            int indexInClass;
            int indexInSource = NewScanner.indexOfNewTree(path, leaf);
            boolean b = this.loc.isBytecodeOffset() ? indexInSource == (indexInClass = NewScanner.getMethodNewIndex(this.methodName, this.loc.offset).intValue()) : indexInSource == this.loc.index;
            return b;
        }
        return this.isSatisfiedBy(path.getParentPath());
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return true;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.NEW;
    }

    public String toString() {
        return "NewCriterion in method: " + this.methodName + " at location " + this.loc;
    }
}

