/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.mustcall.qual.MustCallUnknown;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.EnsuresQualifierIf;

public final class RegexUtil {
    private RegexUtil() {
        throw new Error("do not instantiate");
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String s) {
        return RegexUtil.isRegex(s, 0);
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String s, int groups) {
        Pattern p;
        try {
            p = Pattern.compile(s);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return RegexUtil.getGroupCount(p) >= groups;
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(char c) {
        return RegexUtil.isRegex(Character.toString(c));
    }

    @SideEffectFree
    public static @Regex String asRegex(String s) {
        return RegexUtil.asRegex(s, 0);
    }

    @SideEffectFree
    public static @Regex String asRegex(String s, int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                throw new Error(RegexUtil.regexErrorMessage(s, groups, actualGroups));
            }
            return s;
        }
        catch (PatternSyntaxException e) {
            throw new Error(e);
        }
    }

    @SideEffectFree
    public static @Nullable String regexError(String s) {
        return RegexUtil.regexError(s, 0);
    }

    @SideEffectFree
    public static @Nullable String regexError(String s, int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return RegexUtil.regexErrorMessage(s, groups, actualGroups);
            }
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s) {
        return RegexUtil.regexException(s, 0);
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s, int groups) {
        try {
            Pattern p = Pattern.compile(s);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(s, groups, actualGroups), s, -1);
            }
        }
        catch (PatternSyntaxException pse) {
            return pse;
        }
        return null;
    }

    @SideEffectFree
    private static String regexErrorMessage(String s, int expectedGroups, int actualGroups) {
        return "regex \"" + s + "\" has " + actualGroups + " groups, but " + expectedGroups + " groups are needed.";
    }

    @Pure
    private static int getGroupCount(Pattern p) {
        return p.matcher("").groupCount();
    }

    public static List<String> matchesSomeRegex(Collection<String> strings, Collection<@Regex String> regexes) {
        List<Pattern> patterns = RegexUtil.mapList(Pattern::compile, regexes);
        ArrayList<String> result = new ArrayList<String>(strings.size());
        block0: for (String s : strings) {
            for (Pattern p : patterns) {
                if (!p.matcher(s).matches()) continue;
                result.add(s);
                continue block0;
            }
        }
        return result;
    }

    public static boolean everyStringMatchesSomeRegex(Collection<String> strings, Collection<@Regex String> regexes) {
        List<Pattern> patterns = RegexUtil.mapList(Pattern::compile, regexes);
        block0: for (String s : strings) {
            for (Pattern p : patterns) {
                if (!p.matcher(s).matches()) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static List<String> matchesNoRegex(Collection<String> strings, Collection<@Regex String> regexes) {
        List<Pattern> patterns = RegexUtil.mapList(Pattern::compile, regexes);
        ArrayList<String> result = new ArrayList<String>(strings.size());
        block0: for (String s : strings) {
            for (Pattern p : patterns) {
                if (!p.matcher(s).matches()) continue;
                continue block0;
            }
            result.add(s);
        }
        return result;
    }

    public static boolean noStringMatchesAnyRegex(Collection<String> strings, Collection<@Regex String> regexes) {
        for (String regex : regexes) {
            Pattern p = Pattern.compile(regex);
            for (String s : strings) {
                if (!p.matcher(s).matches()) continue;
                return false;
            }
        }
        return true;
    }

    public static <FROM, TO> List<TO> mapList(@MustCallUnknown Function<@MustCallUnknown ? super FROM, ? extends TO> f, Iterable<FROM> iterable) {
        if (iterable instanceof RandomAccess) {
            List list = (List)iterable;
            int size = list.size();
            ArrayList<TO> result = new ArrayList<TO>(size);
            for (int i = 0; i < size; ++i) {
                result.add(f.apply(list.get(i)));
            }
            return result;
        }
        ArrayList<Object> result = iterable instanceof Collection ? new ArrayList(((Collection)iterable).size()) : new ArrayList<TO>();
        for (FROM elt : iterable) {
            result.add(f.apply(elt));
        }
        return result;
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 6266881831979001480L;
        private final PatternSyntaxException pse;

        public CheckedPatternSyntaxException(PatternSyntaxException pse) {
            this.pse = pse;
        }

        public CheckedPatternSyntaxException(String desc, String regex, @GTENegativeOne int index) {
            this(new PatternSyntaxException(desc, regex, index));
        }

        public String getDescription() {
            return this.pse.getDescription();
        }

        public int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        @Pure
        public String getMessage(@GuardSatisfied CheckedPatternSyntaxException this) {
            return this.pse.getMessage();
        }

        public String getPattern() {
            return this.pse.getPattern();
        }
    }
}

