/*
 * Copyright (c) 2005, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package javax.lang.model.element;

import org.checkerframework.checker.signature.qual.CanonicalNameOrEmpty;
import jdk.internal.javac.PreviewFeature;
import java.util.List;
import javax.lang.model.type.*;
import javax.lang.model.util.*;

public interface TypeElement extends Element, Parameterizable, QualifiedNameable {

    @Override
    TypeMirror asType();

    @Override
    List<? extends Element> getEnclosedElements();

    NestingKind getNestingKind();

    @CanonicalNameOrEmpty
    Name getQualifiedName();

    @Override
    Name getSimpleName();

    @PreviewFeature(feature = PreviewFeature.Feature.UNNAMED_CLASSES, reflective = true)
    default boolean isUnnamed();

    TypeMirror getSuperclass();

    List<? extends TypeMirror> getInterfaces();

    List<? extends TypeParameterElement> getTypeParameters();

    default List<? extends RecordComponentElement> getRecordComponents();

    default List<? extends TypeMirror> getPermittedSubclasses();

    @Override
    Element getEnclosingElement();
}
