/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.scenelib.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.afu.scenelib.Annotation;
import org.checkerframework.afu.scenelib.el.AClass;
import org.checkerframework.afu.scenelib.el.AElement;
import org.checkerframework.afu.scenelib.el.AField;
import org.checkerframework.afu.scenelib.el.AMethod;
import org.checkerframework.afu.scenelib.el.AScene;
import org.checkerframework.afu.scenelib.el.ATypeElement;
import org.checkerframework.afu.scenelib.el.ATypeElementWithType;
import org.checkerframework.afu.scenelib.el.AnnotationDef;
import org.checkerframework.afu.scenelib.el.BoundLocation;
import org.checkerframework.afu.scenelib.el.DefCollector;
import org.checkerframework.afu.scenelib.el.DefException;
import org.checkerframework.afu.scenelib.el.LocalLocation;
import org.checkerframework.afu.scenelib.el.RelativeLocation;
import org.checkerframework.afu.scenelib.el.TypeIndexLocation;
import org.checkerframework.afu.scenelib.el.TypePathEntry;
import org.checkerframework.afu.scenelib.field.AnnotationAFT;
import org.checkerframework.afu.scenelib.field.AnnotationFieldType;
import org.checkerframework.afu.scenelib.field.ArrayAFT;
import org.checkerframework.afu.scenelib.field.BasicAFT;
import org.checkerframework.afu.scenelib.field.ClassTokenAFT;
import org.checkerframework.afu.scenelib.io.ASTPath;
import org.checkerframework.afu.scenelib.io.IOUtils;
import org.checkerframework.afu.scenelib.type.ArrayType;
import org.checkerframework.afu.scenelib.type.BoundedType;
import org.checkerframework.afu.scenelib.type.DeclaredType;
import org.checkerframework.afu.scenelib.type.Type;
import org.checkerframework.afu.scenelib.util.Strings;
import org.objectweb.asm.TypePath;

public final class IndexFileWriter {
    final AScene scene;
    private static final String INDENT = "    ";
    final PrintWriter pw;

    void printAnnotationDefBody(AnnotationDef d) {
        for (Map.Entry<String, AnnotationFieldType> f : d.fieldTypes.entrySet()) {
            String fieldname = f.getKey();
            AnnotationFieldType fieldType = f.getValue();
            this.pw.println(INDENT + fieldType + " " + fieldname);
        }
        this.pw.println();
    }

    private void printAnnotation(Annotation a) {
        StringBuilder sb = new StringBuilder();
        IndexFileWriter.formatAnnotation(sb, a);
        this.pw.print(sb.toString());
    }

    private void printAnnotations(Collection<? extends Annotation> annos) {
        for (Annotation annotation : annos) {
            if (annotation.def.name.contains("+")) continue;
            this.pw.print(' ');
            this.printAnnotation(annotation);
        }
    }

    private void printAnnotations(AElement e) {
        this.printAnnotations(e.tlAnnotationsHere);
        if (e instanceof AMethod) {
            this.printAnnotations(((AMethod)e).contracts);
        }
    }

    private void printElement(String indentation, String descriptor, AElement e) {
        this.pw.print(indentation + descriptor + ":");
        this.printAnnotations(e);
        this.pw.println();
    }

    private void printElementAndInnerTypes(String indentation, String descriptor, AElement e) {
        if (e.type != null) {
            this.printElement(indentation, descriptor, e.type);
            if (!e.type.innerTypes.isEmpty()) {
                this.printInnerTypes(indentation + INDENT, e.type);
            }
        }
    }

    private void printTypeElementAndInnerTypes(String indentation, String descriptor, ATypeElement e) {
        if (e.tlAnnotationsHere.isEmpty() && e.innerTypes.isEmpty() && descriptor.equals("type")) {
            return;
        }
        this.printElement(indentation, descriptor, e);
        this.printInnerTypes(indentation + INDENT, e);
    }

    private void printInnerTypes(String indentation, ATypeElement e) {
        for (Map.Entry ite : e.innerTypes.entrySet()) {
            TypePath typePath = TypePathEntry.listToTypePath((List)ite.getKey());
            AElement it = (AElement)ite.getValue();
            this.pw.print(indentation + "inner-type");
            int sep = 32;
            for (int index = 0; typePath != null && index < typePath.getLength(); ++index) {
                this.pw.print((char)sep);
                this.pw.print(this.typePathStepToString(typePath, index));
                sep = 44;
            }
            this.pw.print(':');
            this.printAnnotations(it);
            this.pw.println();
        }
    }

    private String typePathStepToString(TypePath typePath, int index) {
        int typePathStep = typePath.getStep(index);
        int typePathStepArgument = typePathStep == 3 ? typePath.getStepArgument(index) : 0;
        return typePathStep + ", " + typePathStepArgument;
    }

    private void printNumberedAmbigiousElements(String indentation, String descriptor, Map<Integer, ? extends AElement> nels) {
        for (Map.Entry<Integer, ? extends AElement> te : nels.entrySet()) {
            AElement t = te.getValue();
            this.printAmbElementAndInnerTypes(indentation, descriptor + " #" + te.getKey(), t);
        }
    }

    private void printAmbElementAndInnerTypes(String indentation, String descriptor, AElement e) {
        this.printElement(indentation, descriptor, e);
        if (e.type.tlAnnotationsHere.isEmpty() && e.type.innerTypes.isEmpty()) {
            return;
        }
        this.printElement(indentation + INDENT, "type", e.type);
        for (Map.Entry ite : e.type.innerTypes.entrySet()) {
            TypePath typePath = TypePathEntry.listToTypePath((List)ite.getKey());
            AElement it = (AElement)ite.getValue();
            this.pw.print(indentation + INDENT + INDENT + "inner-type");
            boolean first = true;
            for (int index = 0; index < typePath.getLength(); ++index) {
                if (first) {
                    this.pw.print(' ');
                } else {
                    this.pw.print(',');
                }
                this.pw.print(this.typePathStepToString(typePath, index));
                first = false;
            }
            this.pw.print(':');
            this.printAnnotations(it);
            this.pw.println();
        }
    }

    private void printRelativeElements(String indentation, String descriptor, Map<RelativeLocation, ATypeElement> nels) {
        for (Map.Entry<RelativeLocation, ATypeElement> te : nels.entrySet()) {
            ATypeElement t = te.getValue();
            this.printTypeElementAndInnerTypes(indentation, descriptor + " " + te.getKey().getLocationString(), t);
        }
    }

    private void printRelativeElements(String indentation, String desc1, String desc2, Map<RelativeLocation, ATypeElement> nels) {
        RelativeLocation prev = null;
        for (Map.Entry<RelativeLocation, ATypeElement> te : nels.entrySet()) {
            boolean isOffset;
            ATypeElement t = te.getValue();
            RelativeLocation loc = te.getKey();
            boolean bl = isOffset = loc.index < 0;
            if (prev == null || loc.type_index < 0 || (isOffset ? loc.offset != prev.offset : loc.index != prev.index)) {
                this.pw.print(indentation + desc1 + " ");
                this.pw.print(isOffset ? "#" + loc.offset : "*" + loc.index);
                this.pw.print(":");
                if (loc.type_index <= 0) {
                    this.printAnnotations(t);
                }
                this.pw.println();
                this.printInnerTypes(indentation + INDENT, t);
            }
            if (loc.type_index > 0) {
                this.printTypeElementAndInnerTypes(indentation + INDENT, desc2 + " " + loc.type_index, t);
            }
            prev = loc;
        }
    }

    private void printBounds(String indentation, Map<BoundLocation, ATypeElement> bounds) {
        for (Map.Entry<BoundLocation, ATypeElement> be : bounds.entrySet()) {
            BoundLocation bl = be.getKey();
            ATypeElement b = be.getValue();
            if (bl.boundIndex == -1) {
                this.printTypeElementAndInnerTypes(indentation, "typeparam " + bl.paramIndex, b);
                continue;
            }
            this.printTypeElementAndInnerTypes(indentation, "bound " + bl.paramIndex + " &" + bl.boundIndex, b);
        }
    }

    private void printExtImpls(String indentation, Map<TypeIndexLocation, ATypeElement> extImpls) {
        for (Map.Entry<TypeIndexLocation, ATypeElement> ei : extImpls.entrySet()) {
            TypeIndexLocation idx = ei.getKey();
            ATypeElement ty = ei.getValue();
            if (idx.typeIndex == -1 || idx.typeIndex == 65535) {
                this.printTypeElementAndInnerTypes(indentation, "extends", ty);
                continue;
            }
            this.printTypeElementAndInnerTypes(indentation, "implements " + idx.typeIndex, ty);
        }
    }

    private void printASTInsertions(String indentation, Map<ASTPath, ATypeElement> insertAnnotations, Map<ASTPath, ATypeElementWithType> insertTypecasts) {
        ATypeElement el;
        ASTPath path;
        for (Map.Entry<ASTPath, ATypeElement> entry : insertAnnotations.entrySet()) {
            path = entry.getKey();
            el = entry.getValue();
            this.pw.print(indentation + "insert-annotation " + path + ":");
            this.printAnnotations(el);
            this.pw.println();
            this.printInnerTypes(INDENT, el);
        }
        for (Map.Entry<ASTPath, ATypeElement> entry : insertTypecasts.entrySet()) {
            path = entry.getKey();
            el = (ATypeElementWithType)entry.getValue();
            this.pw.print(indentation + "insert-typecast " + path + ":");
            this.printAnnotations(el);
            this.pw.print(" ");
            this.printType(((ATypeElementWithType)el).getType());
            this.pw.println();
            this.printInnerTypes(INDENT, el);
        }
    }

    private void printType(Type type) {
        switch (type.getKind()) {
            case ARRAY: {
                ArrayType a = (ArrayType)type;
                this.printType(a.getComponentType());
                this.pw.print("[]");
                break;
            }
            case BOUNDED: {
                BoundedType b = (BoundedType)type;
                this.printType(b.getName());
                this.pw.print(" ");
                this.pw.print((Object)b.getBoundKind());
                this.pw.print(" ");
                this.printType(b.getBound());
                break;
            }
            case DECLARED: {
                DeclaredType d = (DeclaredType)type;
                this.pw.print(d.getName());
                if (d.isWildcard()) break;
                DeclaredType inner = d.getInnerType();
                Iterator<Type> iter = d.getTypeParameters().iterator();
                if (iter.hasNext()) {
                    this.pw.print("<");
                    this.printType(iter.next());
                    while (iter.hasNext()) {
                        this.pw.print(", ");
                        this.printType(iter.next());
                    }
                    this.pw.print(">");
                }
                if (inner == null) break;
                this.pw.print(".");
                this.printType(inner);
            }
        }
    }

    private void write() throws DefException {
        OurDefCollector odc = new OurDefCollector();
        odc.visit();
        for (Map.Entry pe : this.scene.packages.entrySet()) {
            AElement elem = (AElement)pe.getValue();
            if (elem == null || elem.tlAnnotationsHere.isEmpty()) continue;
            this.pw.print("package " + (String)pe.getKey() + ":");
            this.printAnnotations(elem);
            this.pw.println();
        }
        String indent2 = "        ";
        String indent3 = "            ";
        for (Map.Entry ce : this.scene.classes.entrySet()) {
            String cname = (String)ce.getKey();
            AClass c = (AClass)ce.getValue();
            String pkg = IOUtils.packagePart(cname);
            String basename = IOUtils.basenamePart(cname);
            if ("package-info".equals(basename)) {
                if (c.tlAnnotationsHere.isEmpty()) continue;
                this.pw.print("package " + pkg + ":");
                this.printAnnotations(c);
                this.pw.println();
                continue;
            }
            this.pw.println("package " + pkg + ":");
            this.pw.print("class " + basename + ":");
            this.printAnnotations(c);
            this.pw.println();
            this.printBounds(INDENT, c.bounds);
            this.printExtImpls(INDENT, c.extendsImplements);
            this.printASTInsertions(INDENT, c.insertAnnotations, c.insertTypecasts);
            for (Map.Entry fe : c.fields.entrySet()) {
                String fname = (String)fe.getKey();
                AField f = (AField)fe.getValue();
                this.pw.println();
                this.printElement(INDENT, "field " + fname, f);
                this.printTypeElementAndInnerTypes("        ", "type", f.type);
                this.printASTInsertions("        ", f.insertAnnotations, f.insertTypecasts);
            }
            for (Map.Entry me : c.methods.entrySet()) {
                String mkey = (String)me.getKey();
                AMethod m = (AMethod)me.getValue();
                this.pw.println();
                this.printElement(INDENT, "method " + mkey, m);
                this.printBounds("        ", m.bounds);
                this.printTypeElementAndInnerTypes("        ", "return", m.returnType);
                if (!m.receiver.type.tlAnnotationsHere.isEmpty() || !m.receiver.type.innerTypes.isEmpty()) {
                    this.printElementAndInnerTypes("        ", "receiver", m.receiver);
                }
                this.printNumberedAmbigiousElements("        ", "parameter", m.parameters);
                for (Map.Entry le : m.body.locals.entrySet()) {
                    LocalLocation loc = (LocalLocation)le.getKey();
                    AElement l = (AElement)le.getValue();
                    StringBuilder sb = new StringBuilder("local ");
                    sb.append(loc.variableName == null ? loc.getVarIndex() + " #" + loc.getScopeStart() + "+" + loc.getScopeLength() : loc.variableName);
                    this.printElement("        ", sb.toString(), l);
                    this.printTypeElementAndInnerTypes("            ", "type", l.type);
                }
                this.printRelativeElements("        ", "typecast", m.body.typecasts);
                this.printRelativeElements("        ", "instanceof", m.body.instanceofs);
                this.printRelativeElements("        ", "new", m.body.news);
                this.printRelativeElements("        ", "reference", "typearg", m.body.refs);
                this.printRelativeElements("        ", "call", "typearg", m.body.calls);
                for (Map.Entry entry : m.body.funs.entrySet()) {
                    AMethod lambda = (AMethod)entry.getValue();
                    RelativeLocation loc = (RelativeLocation)entry.getKey();
                    this.pw.print("lambda " + loc.getLocationString() + ":\n");
                    this.printBounds("            ", lambda.bounds);
                    this.printTypeElementAndInnerTypes("            ", "return", lambda.returnType);
                }
                this.printASTInsertions("        ", m.insertAnnotations, m.insertTypecasts);
            }
            this.pw.println();
        }
    }

    private IndexFileWriter(AScene scene, Writer out) throws DefException {
        this.scene = scene;
        this.pw = new PrintWriter(out);
        this.write();
        this.pw.flush();
    }

    private static void formatAnnotation(StringBuilder sb, Annotation a) {
        sb.append("@");
        sb.append(a.def().name);
        if (a.fieldValues.isEmpty()) {
            return;
        }
        sb.append("(");
        boolean notfirst = false;
        for (Map.Entry<String, Object> f : a.fieldValues.entrySet()) {
            if (notfirst) {
                sb.append(",");
            } else {
                notfirst = true;
            }
            AnnotationFieldType aft = a.def().fieldTypes.get(f.getKey());
            sb.append(f.getKey());
            sb.append("=");
            IndexFileWriter.formatAnnotationValue(sb, aft, f.getValue());
        }
        sb.append(")");
    }

    @Deprecated
    public static String formatAnnotationValue(AnnotationFieldType aft, Object o) {
        StringBuilder sb = new StringBuilder();
        IndexFileWriter.formatAnnotationValue(sb, aft, o);
        return sb.toString();
    }

    public static void formatAnnotationValue(StringBuilder sb, AnnotationFieldType aft, Object o) {
        if (aft instanceof AnnotationAFT) {
            IndexFileWriter.formatAnnotation(sb, (Annotation)o);
        } else if (aft instanceof ArrayAFT) {
            ArrayAFT aaft = (ArrayAFT)aft;
            List l = (List)o;
            sb.append("{");
            if (aaft.elementType == null) {
                if (!l.isEmpty()) {
                    throw new AssertionError((Object)"nonempty array of unknown type");
                }
            } else {
                boolean notfirst = false;
                for (Object o2 : l) {
                    if (notfirst) {
                        sb.append(",");
                    } else {
                        notfirst = true;
                    }
                    IndexFileWriter.formatAnnotationValue(sb, aaft.elementType, o2);
                }
            }
            sb.append("}");
        } else if (aft instanceof ClassTokenAFT) {
            aft.format(sb, o);
        } else if (aft instanceof BasicAFT && o instanceof String) {
            sb.append(Strings.escape((String)o));
        } else if (aft instanceof BasicAFT && o instanceof Long) {
            sb.append(o.toString());
            sb.append("L");
        } else {
            sb.append(o.toString());
        }
    }

    public static void write(AScene scene, Writer out) throws DefException {
        new IndexFileWriter(scene, out);
    }

    public static void write(AScene scene, String filename) throws IOException, DefException {
        try (BufferedWriter w = Files.newBufferedWriter(Paths.get(filename, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            IndexFileWriter.write(scene, w);
        }
    }

    private class OurDefCollector
    extends DefCollector {
        OurDefCollector() throws DefException {
            super(IndexFileWriter.this.scene);
        }

        @Override
        protected void visitAnnotationDef(AnnotationDef d) {
            if (!d.name.contains("+")) {
                IndexFileWriter.this.pw.println("package " + IOUtils.packagePart(d.name) + ":");
                IndexFileWriter.this.pw.print("annotation @" + IOUtils.basenamePart(d.name) + ":");
                IndexFileWriter.this.printAnnotations(this.requiredMetaannotations(d.tlAnnotationsHere));
                IndexFileWriter.this.pw.println();
                IndexFileWriter.this.printAnnotationDefBody(d);
            }
        }

        private Collection<Annotation> requiredMetaannotations(Collection<Annotation> annos) {
            HashSet<Annotation> results = new HashSet<Annotation>();
            for (Annotation a : annos) {
                String aName = a.def.name;
                if (!aName.equals(Retention.class.getCanonicalName()) && !aName.equals(Target.class.getCanonicalName())) continue;
                results.add(a);
            }
            return results;
        }
    }
}

