/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.afu.annotator.find;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Pair;
import java.util.List;
import java.util.Objects;
import org.checkerframework.afu.annotator.find.Criterion;
import org.checkerframework.afu.annotator.scanner.LocalVariableScanner;
import org.checkerframework.afu.scenelib.el.LocalLocation;
import org.checkerframework.checker.interning.qual.FindDistinct;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LocalVariableCriterion
implements Criterion {
    private final String fullMethodName;
    private final LocalLocation loc;

    public LocalVariableCriterion(String methodName, LocalLocation loc) {
        this.fullMethodName = methodName.substring(0, methodName.indexOf(41) + 1);
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path, @FindDistinct Tree leaf) {
        if (path == null) {
            return false;
        }
        assert (path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(@Nullable TreePath path) {
        if (path == null) {
            return false;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath == null) {
            return false;
        }
        Tree parent = parentPath.getLeaf();
        Tree leaf = path.getLeaf();
        if (parent instanceof VariableTree) {
            Pair<String, Pair<Integer, Integer>> key;
            String potentialVarName;
            if (parentPath.getParentPath().getLeaf() instanceof MethodTree) {
                return false;
            }
            VariableTree vtt = (VariableTree)parent;
            if (leaf.equals(vtt.getInitializer())) {
                return false;
            }
            String varName = vtt.getName().toString();
            if (Objects.equals(this.loc.variableName, varName)) {
                int varIndex = LocalVariableScanner.indexOfVarTree(path, vtt, varName);
                return this.loc.getVarIndex() == varIndex;
            }
            if (this.loc.scopeStartDefined() && (potentialVarName = LocalVariableScanner.getFromMethodNameIndexMap(key = Pair.of(this.fullMethodName, Pair.of(this.loc.getVarIndex(), this.loc.getScopeStart())))) != null && varName.equals(potentialVarName)) {
                List<Integer> allOffsetsWithThisName = LocalVariableScanner.getFromMethodNameCounter(this.fullMethodName, potentialVarName);
                Integer thisVariablesOffset = allOffsetsWithThisName.indexOf(this.loc.getScopeStart());
                int i = LocalVariableScanner.indexOfVarTree(path, parent, potentialVarName);
                if (i == thisVariablesOffset) {
                    return true;
                }
            }
            return false;
        }
        if (parent instanceof MethodTree) {
            return false;
        }
        return this.isSatisfiedBy(parentPath);
    }

    @Override
    public boolean isOnlyTypeAnnotationCriterion() {
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.LOCAL_VARIABLE;
    }

    public String toString() {
        return "LocalVariableCriterion: in: " + this.fullMethodName + " loc: " + this.loc;
    }
}

